<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTradeGroupsTable extends Migration {

	public function up()
	{
		Schema::create('trade_groups', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->string('surname')->unique();
			$table->string('slug')->unique();
			$table->string('icon', 25);
			$table->longText('description');
			$table->string('cover_file');
		});
	}

	public function down()
	{
		Schema::drop('trade_groups');
	}
}