<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTownsTable extends Migration {

	public function up()
	{
		Schema::create('towns', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->string('slug')->unique();
			$table->longText('description');
			$table->bigInteger('image');
		});
	}

	public function down()
	{
		Schema::drop('towns');
	}
}