<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExperiencesTable extends Migration {

	public function up()
	{
		Schema::create('experiences', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('society');
			$table->string('title');
			$table->date('start_date');
			$table->date('end_date')->nullable();
			$table->longText('description')->nullable();
			$table->bigInteger('sector_id')->unsigned();
			$table->bigInteger('town_id')->unsigned();
			$table->bigInteger('profile_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('experiences');
	}
}