<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Application extends Eloquent {

	protected $table = 'application';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function transcriptions()
	{
		return $this->hasMany('Transcription', 'application_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

}