<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAuditResultTable extends Migration {

	public function up()
	{
		Schema::create('audit_result', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('transcription_id')->unsigned()->index();
			$table->enum('grade', array('unacceptable', 'needs_improvement', 'satisfactory'));
			$table->text('comments')->nullable();
			$table->enum('type', array('QA', 'Audit'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('audit_result');
	}
}