<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pivot_cand_tech', function(Blueprint $table) {
			$table->foreign('candidate_id')->references('id')->on('candidates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pivot_cand_tech', function(Blueprint $table) {
			$table->foreign('tech_id')->references('id')->on('tech')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('position')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('proficiency_level_id')->references('id')->on('level_of_proficiency')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('employment_status_id')->references('id')->on('employment_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pivot_employment_tech', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employee')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pivot_employment_tech', function(Blueprint $table) {
			$table->foreign('tech_id')->references('id')->on('tech')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('day_off', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('day_off', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employee')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salary_review', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employee')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('pivot_cand_tech', function(Blueprint $table) {
			$table->dropForeign('pivot_cand_tech_candidate_id_foreign');
		});
		Schema::table('pivot_cand_tech', function(Blueprint $table) {
			$table->dropForeign('pivot_cand_tech_tech_id_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_department_id_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_position_id_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_proficiency_level_id_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_employment_status_id_foreign');
		});
		Schema::table('pivot_employment_tech', function(Blueprint $table) {
			$table->dropForeign('pivot_employment_tech_employee_id_foreign');
		});
		Schema::table('pivot_employment_tech', function(Blueprint $table) {
			$table->dropForeign('pivot_employment_tech_tech_id_foreign');
		});
		Schema::table('day_off', function(Blueprint $table) {
			$table->dropForeign('day_off_category_id_foreign');
		});
		Schema::table('day_off', function(Blueprint $table) {
			$table->dropForeign('day_off_employee_id_foreign');
		});
		Schema::table('salary_review', function(Blueprint $table) {
			$table->dropForeign('salary_review_employee_id_foreign');
		});
	}
}