<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 30);
			$table->string('surname', 30);
			$table->string('password', 64);
			$table->enum('type', array('admin', 'manager', 'engineer', 'user'));
			$table->enum('language', array('lt', 'en'));
			$table->string('phonenumber', 30);
			$table->string('email', 100);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}