<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLogTable extends Migration {

	public function up()
	{
		Schema::create('log', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('request_id')->unsigned();
			$table->integer('administrator_id')->unsigned()->nullable();
			$table->integer('engineer_id')->unsigned()->nullable();
			$table->datetime('time_assigned');
			$table->datetime('time_returned')->nullable();
			$table->string('comment', 300)->nullable();
			$table->enum('result', array('solved', 'rejected', 'return'))->nullable();
			$table->integer('time_consumed')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('log');
	}
}