<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('service_samples', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->foreign('blog_category_id')->references('id')->on('blog_categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->foreign('blog_category_id')->references('id')->on('blog_categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('blog_comments', function(Blueprint $table) {
			$table->foreign('blog_post_id')->references('id')->on('blog_posts')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('blog_post_tags', function(Blueprint $table) {
			$table->foreign('blog_post_id')->references('id')->on('blog_posts')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('blog_post_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_sample_tags', function(Blueprint $table) {
			$table->foreign('service_sample_id')->references('id')->on('service_samples')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_sample_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('media')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('service_samples', function(Blueprint $table) {
			$table->dropForeign('service_samples_media_id_foreign');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->dropForeign('blog_posts_blog_category_id_foreign');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->dropForeign('blog_posts_blog_category_id_foreign');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->dropForeign('blog_posts_media_id_foreign');
		});
		Schema::table('blog_comments', function(Blueprint $table) {
			$table->dropForeign('blog_comments_blog_post_id_foreign');
		});
		Schema::table('blog_post_tags', function(Blueprint $table) {
			$table->dropForeign('blog_post_tags_blog_post_id_foreign');
		});
		Schema::table('blog_post_tags', function(Blueprint $table) {
			$table->dropForeign('blog_post_tags_tag_id_foreign');
		});
		Schema::table('service_sample_tags', function(Blueprint $table) {
			$table->dropForeign('service_sample_tags_service_sample_id_foreign');
		});
		Schema::table('service_sample_tags', function(Blueprint $table) {
			$table->dropForeign('service_sample_tags_tag_id_foreign');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->dropForeign('partners_media_id_foreign');
		});
	}
}