<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMeetingsTable extends Migration {

	public function up()
	{
		Schema::create('meetings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 150);
			$table->integer('employee_id')->unsigned();
			$table->datetime('meeting_date');
			$table->integer('meeting_room_id')->unsigned();
			$table->string('type', 20);
			$table->smallInteger('meeting_duration')->nullable();
			$table->text('note');
			$table->enum('status', array('pending', 'approved', 'rejected'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('meetings');
	}
}