<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateManagementsTable extends Migration {

	public function up()
	{
		Schema::create('managements', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('parent_id')->unsigned()->nullable();
			$table->string('image')->nullable();
			$table->text('description')->nullable();
			$table->timestamp('deactivated_at')->nullable();
			$table->timestamp('deleted_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('managements');
	}
}