<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerServicesTable extends Migration {

	public function up()
	{
		Schema::create('customer_services', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id')->unsigned();
			$table->string('status', 40);
			$table->integer('calls_count')->unsigned()->default('1');
			$table->integer('sms_messages_count')->unsigned()->default('1');
			$table->integer('whatsapp_messages_count')->unsigned()->default('1');
			$table->time('call_duration');
			$table->time('call_duration_average');
			$table->double('rate');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customer_services');
	}
}