<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustodiesTable extends Migration {

	public function up()
	{
		Schema::create('custodies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type')->nullable();
			$table->integer('count')->unsigned()->nullable();
			$table->text('description')->nullable();
			$table->date('received_date');
			$table->date('delivery_date')->nullable();
			$table->integer('employee_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('custodies');
	}
}