<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('phone', 'name', 'email', 'date_of_birth');
    protected $hidden = array('password');

    public function city()
    {
        return $this->belongsTo('App/Models\City');
    }

    public function clientPost()
    {
        return $this->belongsToMany('App/Models\ClientPost');
    }

}