<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateObjectImageTable extends Migration {

	public function up()
	{
		Schema::create('object_image', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('object_id')->unsigned();
			$table->string('name', 128)->nullable();
			$table->string('description', 128)->nullable();
			$table->boolean('is_diagram')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('object_image');
	}
}