<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateObjectDocumentTable extends Migration {

	public function up()
	{
		Schema::create('object_document', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 128)->nullable();
			$table->enum('type', array('Brochure', 'DissasemblyProcedure', 'Manual', 'RiskAssesment', 'RSP'));
		});
	}

	public function down()
	{
		Schema::drop('object_document');
	}
}