<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Setting extends Eloquent {

	protected $table = 'settings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Environment()
	{
		return $this->belongsTo('Environment');
	}

	public function Timers()
	{
		return $this->hasMany('TimerSetting');
	}

	public function Incubator()
	{
		return $this->hasOne('IncubatorSettings');
	}

	public function VivariumSetting()
	{
		return $this->hasOne('VivariumSettings');
	}

}