<?php

namespace Announcement;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Announcement extends Eloquent {

	protected $table = 'announcements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function brands()
	{
		return $this->hasMany('AnnouncementBrand');
	}

	public function brandches()
	{
		return $this->hasMany('AnnouncementBranch');
	}

	public function members()
	{
		return $this->hasMany('AnnouncementMember');
	}

}