<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnnouncementsTable extends Migration {

	public function up()
	{
		Schema::create('announcements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('company_id')->unsigned();
			$table->string('title');
			$table->longText('content');
			$table->date('start_date');
			$table->time('start_time');
			$table->enum('urgency_level', array('low', 'medium', 'high'));
			$table->enum('schedule_option', array('once', 'daily', 'weekly', 'monthly'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('announcements');
	}
}