<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('triggers', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('channels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('triggers', function(Blueprint $table) {
			$table->foreign('questionnaire_id')->references('id')->on('questionnaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('responses', function(Blueprint $table) {
			$table->foreign('attempt_id')->references('id')->on('attempts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('responses', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questionnaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rules', function(Blueprint $table) {
			$table->foreign('trigger_id')->references('id')->on('triggers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('feedbacks', function(Blueprint $table) {
			$table->foreign('attempt_id')->references('id')->on('attempts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('buckets', function(Blueprint $table) {
			$table->foreign('rule_id')->references('id')->on('rules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hits', function(Blueprint $table) {
			$table->foreign('trigger_id')->references('id')->on('triggers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hits', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('channels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('triggers', function(Blueprint $table) {
			$table->dropForeign('triggers_channel_id_foreign');
		});
		Schema::table('triggers', function(Blueprint $table) {
			$table->dropForeign('triggers_questionnaire_id_foreign');
		});
		Schema::table('responses', function(Blueprint $table) {
			$table->dropForeign('responses_attempt_id_foreign');
		});
		Schema::table('responses', function(Blueprint $table) {
			$table->dropForeign('responses_question_id_foreign');
		});
		Schema::table('rules', function(Blueprint $table) {
			$table->dropForeign('rules_trigger_id_foreign');
		});
		Schema::table('feedbacks', function(Blueprint $table) {
			$table->dropForeign('feedbacks_attempt_id_foreign');
		});
		Schema::table('buckets', function(Blueprint $table) {
			$table->dropForeign('buckets_rule_id_foreign');
		});
		Schema::table('hits', function(Blueprint $table) {
			$table->dropForeign('hits_trigger_id_foreign');
		});
		Schema::table('hits', function(Blueprint $table) {
			$table->dropForeign('hits_channel_id_foreign');
		});
	}
}