<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttemptsTable extends Migration {

	public function up()
	{
		Schema::create('attempts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid', 54)->index();
			$table->string('msisdn', 11);
			$table->string('type', 250);
			$table->string('event', 250);
			$table->string('channel', 250);
			$table->json('trigger_matches')->default('[]');
			$table->binary('taken');
			$table->timestamp('tried_at')->nullable();
			$table->string('platform', 500)->nullable();
			$table->string('device_id', 1000)->nullable();
			$table->string('model', 500)->nullable();
			$table->string('arpu', 100)->nullable();
			$table->enum('customer_behavior', array('voice_user', 'data_user'))->nullable();
			$table->string('loyalty_level', 100)->nullable();
			$table->string('district')->nullable();
			$table->string('city')->nullable();
			$table->string('thana')->nullable();
			$table->integer('pick_agent_id')->nullable();
			$table->enum('cfl_status', array('open', 'close', 'wip'))->index();
			$table->timestamp('cfl_status_updated_at')->nullable();
			$table->string('remarks', 1000)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('attempts');
	}
}