<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProduitsNumeriquesTable extends Migration {

	public function up()
	{
		Schema::create('produits_numeriques', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('label', array('ApplicationMobile', 'Ecobankpay', 'EcobankOnline', 'CompteXpress', 'VisaVirtuelle', 'RelevéElectronique(e-Statement)', 'AlerteElectronique(e-Alert)', 'SMS'))->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('produits_numeriques');
	}
}