<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParentsTable extends Migration {

	public function up()
	{
		Schema::create('parents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('Père', 'Mère', 'ProcheParent1', 'ProcheParent1'))->nullable();
			$table->string('nom', 255)->nullable();
			$table->string('prenom', 255)->nullable();
			$table->string('prenom2', 255)->nullable();
			$table->string('relation', 255)->nullable();
			$table->string('tel', 255)->nullable();
			$table->string('tel2', 255)->nullable();
			$table->string('adresse', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->integer('client')->unsigned();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('parents');
	}
}