<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEffectifsPourComptesTable extends Migration {

	public function up()
	{
		Schema::create('effectifs_pour_comptes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('categorie', array('Personnephysique', 'Comptejoint', 'Entrepriseindividuelle'))->nullable();
			$table->boolean('lettre_indemnisation')->nullable();
			$table->boolean('signature_cachet')->nullable();
			$table->boolean('confirmation_cheque')->nullable();
			$table->string('instructions_amountToConfirm');
			$table->integer('compte')->unsigned();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('effectifs_pour_comptes');
	}
}