<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComptesTable extends Migration {

	public function up()
	{
		Schema::create('comptes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('clientType', array('Particulier', 'Entrepriseindividuelle'))->nullable();
			$table->string('devise', 10)->nullable();
			$table->integer('client')->unsigned();
			$table->enum('objectif', array('Salaire', 'Affaires'))->nullable();
			$table->enum('categorie', array('Résident', 'Étudiant', 'Non-résident', 'Personnepolitiquementexposèe(PPE)', 'Homme/Femmeaffaires'))->nullable();
			$table->string('depotInitial', 255)->nullable();
			$table->enum('methode_financement_pref', array('Argentmobile', 'Virementbancaire', 'Espèces', 'Chèque'))->nullable();
			$table->date('signature_date')->nullable();
			$table->string('interpreter_name', 255)->nullable();
			$table->string('interpreter_address', 255)->nullable();
			$table->string('interpreter_language', 255)->nullable();
			$table->string('bank_accountNumber', 255)->nullable();
			$table->string('bank_customerld', 255)->nullable();
			$table->string('bank_accountofficer');
			$table->string('bank_branchCode')->nullable();
			$table->date('date_approbation');
			$table->string('bank_approvedBy')->nullable();
			$table->string('risques', 255)->nullable();
			$table->string('statut_verification', 255)->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('comptes');
	}
}