<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccesCompte extends Model 
{

    protected $table = 'acces_comptes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function accesService()
    {
        return $this->belongsTo('AccesService', 'acces_service');
    }

    public function compte()
    {
        return $this->belongsTo('Compte', 'compte');
    }

}