<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceCompte extends Eloquent {

	protected $table = 'services_comptes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function compte()
	{
		return $this->belongsTo('Compte', 'compte');
	}

	public function serviceFinancier()
	{
		return $this->belongsTo('ServiceFinancier', 'service_financier');
	}

}