<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBancassurancesTable extends Migration {

	public function up()
	{
		Schema::create('bancassurances', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('label', array('FRAISD'ENTERREMENT', 'MRH', 'CARTES', 'COMPTEPARRAIN/TUTEUR', 'SANTÉ', 'AUTO'))->nullable();
			$table->string('fraisEnterrement', 255)->nullable();
			$table->string('mrh', 255)->nullable();
			$table->string('compteParrain', 255)->nullable();
			$table->string('sante', 255)->nullable();
			$table->string('auto', 255)->nullable();
			$table->string('cartes', 255)->nullable();
			$table->integer('compte')->unsigned()->nullable();
			$table->string('status', 10)->default('0');
		});
	}

	public function down()
	{
		Schema::drop('bancassurances');
	}
}