<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatusEmploiTable extends Migration {

	public function up()
	{
		Schema::create('status_emploi', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client')->unsigned()->nullable();
			$table->enum('situation', array('Salarié', 'Entrepreneurindividuel', 'Étudiant'))->nullable();
			$table->enum('trancheevenu', array('Moinsde150000', '150001-499999', 'Plusde500000'))->nullable();
			$table->string('salaried_employerName', 255)->nullable();
			$table->string('salaried_designation', 255)->nullable();
			$table->string('salaried_industry', 255)->nullable();
			$table->enum('salaried_condition', array('Permanent', 'contrat'))->nullable();
			$table->string('soleProprietor_businessName', 255)->nullable();
			$table->string('soleProprietor_registrationNo', 255)->nullable();
			$table->string('soleProprietor_kraPin', 255)->nullable();
			$table->string('soleProprietor_nature', 255)->nullable();
			$table->string('student_institutionName', 255)->nullable();
			$table->string('student_location', 255)->nullable();
			$table->string('student_program', 255)->nullable();
			$table->string('student_id', 255)->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('status_emploi');
	}
}