<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesFinanciersTable extends Migration {

	public function up()
	{
		Schema::create('services_financiers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('label', array('Épargne', 'Transferts', 'Assurance', 'Investissements'))->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('services_financiers');
	}
}