<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRelevesComptesTable extends Migration {

	public function up()
	{
		Schema::create('releves_comptes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('compte')->unsigned()->nullable();
			$table->enum('modeEnvoi', array('COURRIEL/E-MAIL', 'AGENCE/IN-BRANCH', 'LIVRAISONSPÉCIALE'))->nullable();
			$table->enum('periode', array('TRIMESTRIEL', 'MENSUEL'))->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('releves_comptes');
	}
}