<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('titre', array('M.', 'Mme', 'Mlle', 'Dr', 'Prof.'))->nullable();
			$table->string('firstName', 255)->nullable();
			$table->string('middleName', 255)->nullable();
			$table->string('lastName', 255)->nullable();
			$table->string('nationality', 255)->nullable();
			$table->string('placeOfBirth', 255)->nullable();
			$table->string('dateDeNaissance', 255)->nullable();
			$table->enum('genre', array('Homme', 'Femme'));
			$table->enum('etatCivil', array('Célibataire', 'Marié(e)', 'Veuf/Veuve', 'Divorcé(e)'));
			$table->integer('residenceCountry')->unsigned()->nullable();
			$table->string('tel', 255)->nullable();
			$table->string('tel2', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('adresse', 255)->nullable();
			$table->string('nui', 255)->nullable();
			$table->string('rccm', 255)->nullable();
			$table->string('gps_longitude', 255)->nullable();
			$table->string('gps_latitude', 255)->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}