<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRelationsInBankTable extends Migration {

	public function up()
	{
		Schema::create('relations_in_bank', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client')->unsigned()->nullable();
			$table->string('name', 255)->nullable();
			$table->string('tel', 255)->nullable();
			$table->string('existingAccountNumber', 255)->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('relations_in_bank');
	}
}