<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartesTable extends Migration {

	public function up()
	{
		Schema::create('cartes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('compte')->unsigned()->nullable();
			$table->enum('visa', array('Classic', 'MX', 'OR', 'PLATINIUM'))->nullable();
			$table->enum('prepaye', array('CLASSIQUE', 'INTERMÉDIAIRE', 'AFFAIRES'))->nullable();
			$table->string('autres', 255)->nullable();
			$table->string('status', 10)->default('0');
		});
	}

	public function down()
	{
		Schema::drop('cartes');
	}
}