<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWsAnalyticsTable extends Migration {

	public function up()
	{
		Schema::create('ws_analytics', function(Blueprint $table) {
			$table->integer('aid', true);
			$table->timestamp('timestamp');
			$table->integer('sid');
			$table->string('query', 1024);
			$table->text('page_id');
			$table->integer('rank');
			$table->integer('collection_id');
			$table->string('action', 255);
			$table->integer('origin_id');
			$table->integer('log_type');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('ws_analytics');
	}
}