<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('fullname', 255)->default('Name Surname');
			$table->string('username', 25);
			$table->string('password', 255);
			$table->string('email', 50);
			$table->string('referral', 255);
			$table->string('referrer', 255);
			$table->string('login_hash', 50);
			$table->string('ip', 15);
			$table->tinyInteger('verified')->default('0');
			$table->string('facebookid', 255);
			$table->string('cid', 16);
			$table->integer('tid')->default('0');
			$table->integer('privileges')->default('0');
			$table->timestamp('updated');
			$table->timestamp('registered');
			$table->text('refresh_tokens');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}