<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('u_notifications', function(Blueprint $table) {
			$table->integer('nid', true);
			$table->string('type', 255)->nullable()->default('''');
			$table->string('belongs', 1024)->default('0');
			$table->string('title', 150)->nullable()->default('''');
			$table->text('body')->nullable();
			$table->string('browsers', 2560)->default('''');
			$table->timestamp('date');
			$table->integer('status')->default('1');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('u_notifications');
	}
}