<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ws_twitternews_sources', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('ws_twitternews_locations')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('ws_twitternews_sources', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('ws_twitternews_categories')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('ws_twitternews_tweets', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('ws_twitternews_sources')
						->onDelete('set null')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('ws_twitternews_sources', function(Blueprint $table) {
			$table->dropForeign('ws_twitternews_sources_location_id_foreign');
		});
		Schema::table('ws_twitternews_sources', function(Blueprint $table) {
			$table->dropForeign('ws_twitternews_sources_category_id_foreign');
		});
		Schema::table('ws_twitternews_tweets', function(Blueprint $table) {
			$table->dropForeign('ws_twitternews_tweets_source_id_foreign');
		});
	}
}