<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNamesTable extends Migration {

	public function up()
	{
		Schema::create('names', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('image')->nullable();
			$table->string('name');
			$table->bigInteger('group_id')->unsigned()->nullable();
			$table->integer('number_of_vlaues')->default('0');
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('names');
	}
}