<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupsTable extends Migration {

	public function up()
	{
		Schema::create('groups', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('image')->nullable();
			$table->string('name');
			$table->text('description')->nullable();
			$table->integer('number_of_name')->default('0');
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('groups');
	}
}