<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAudiencesTable extends Migration {

	public function up()
	{
		Schema::create('audiences', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->enum('gender', array('male', 'female'));
			$table->integer('min_age');
			$table->integer('max_age');
			$table->bigInteger('job_id')->unsigned();
			$table->boolean('married')->default(0);
			$table->boolean('has_child')->default(0);
			$table->integer('child_min_age');
			$table->integer('child_max_age');
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('audiences');
	}
}