<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserSocialProfileTable extends Migration {

	public function up()
	{
		Schema::create('user_social_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('account_id')->unsigned();
			$table->string('username');
			$table->string('full_name');
			$table->string('nick_name');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('url');
			$table->string('introduction');
			$table->string('image_url');
			$table->string('date_of_birth');
			$table->string('external_id');
			$table->string('platform_account_type');
			$table->string('category');
			$table->string('website');
			$table->string('gender');
			$table->json('emails');
			$table->json('phone_numbers');
			$table->json('addresses');
			$table->string('country');
			$table->string('platform_profile_name');
			$table->string('platform_profile_id');
			$table->string('is_verified');
			$table->boolean('is_business');
			$table->string('follower_count');
			$table->string('following_count');
			$table->string('subscriber_count');
			$table->string('content_count');
			$table->string('content_group_count');
			$table->string('watch_time_in_hours');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_social_profile');
	}
}