<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserKycTable extends Migration {

	public function up()
	{
		Schema::create('user_kyc', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('title');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('gender');
			$table->string('dob');
			$table->string('address');
			$table->string('address2');
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->string('pincode');
			$table->string('idType');
			$table->string('idNumber');
			$table->string('idExpiry');
			$table->string('programType');
			$table->string('kycStatus');
			$table->json('documents');
			$table->string('eKycRefNo');
			$table->string('description');
			$table->string('uid');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_kyc');
	}
}