<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Places extends Eloquent {

	protected $table = 'places';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function type()
	{
		return $this->belongsTo('TypePlaces', 'id_type_place');
	}

	public function country()
	{
		return $this->belongsTo('Countries');
	}

	public function province()
	{
		return $this->belongsTo('Provinces');
	}

}