<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScheduleTable extends Migration {

	public function up()
	{
		Schema::create('schedule', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_place')->unsigned();
			$table->integer('id_type_activity')->unsigned()->nullable();
			$table->string('title', 255);
			$table->string('address', 255);
			$table->decimal('lat')->nullable();
			$table->decimal('long')->nullable();
			$table->text('description');
			$table->integer('date_start');
			$table->integer('date_end')->nullable();
			$table->integer('id_location')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('schedule');
	}
}