<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReferenceTable extends Migration {

	public function up()
	{
		Schema::create('reference', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->text('description')->nullable();
			$table->float('patient_amount')->default('0');
			$table->float('reference_amount')->default('0');
			$table->enum('amount_type', array('percent', 'fixed'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reference');
	}
}