<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('invoice_payments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('invoice_id');
			$table->integer('patient_id');
			$table->float('amount')->default('0');
			$table->date('date');
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice_payments');
	}
}