<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('doctor_id');
			$table->integer('patient_id');
			$table->date('day')->nullable();
			$table->time('time_from')->nullable();
			$table->time('time_to')->nullable();
			$table->text('notes')->nullable();
			$table->enum('status', array('pending', 'treated', 'confirmed', 'cancelled', ''))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}