<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Donor extends Model 
{

    protected $table = 'donors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('category_id', 'name', 'phone', 'email', 'last_donation_date', 'date', 'age', 'gender');

    public function category()
    {
        return $this->belongsTo('Models\Category', 'category_id');
    }

}