<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Doctor extends Model 
{

    protected $table = 'docotors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'phone', 'department_id', 'address', 'image', 'profile');

    public function department()
    {
        return $this->belongsTo('Models\Department', 'department_id');
    }

    public function appointments()
    {
        return $this->hasMany('Models\Appointment', 'doctor_id');
    }

    public function time_schedules()
    {
        return $this->hasMany('Models\TimeSchedul', 'doctor_id');
    }

    public function holidays()
    {
        return $this->hasMany('Models\Holiday', 'doctor_id');
    }

}